;;###########################################################################
;; icons2.lsp
;; second file of code to implement button icon objects 
;; Copyright (c) 1992-98 by Forrest W. Young
;;###########################################################################

(defun make-button (w type &optional (x 0) (y 0) &key color)
  (send button-icon-proto :new w x y type color))
    
(defproto button-icon-proto 
  '(draw-color shadow19v shadow19h) nil icon-proto)

(defmeth button-icon-proto :draw-color (&optional (draw-color nil set))
  (if set (setf (slot-value 'draw-color) draw-color))
  (slot-value 'draw-color))

(defmeth button-icon-proto :shadow19v (&optional (matrix nil set))
  (if set (setf (slot-value 'shadow19v) matrix))
  (slot-value 'shadow19v))

(defmeth button-icon-proto :shadow19h (&optional (matrix nil set))
  (if set (setf (slot-value 'shadow19h) matrix))
  (slot-value 'shadow19h))

;;define prototype graph and stats icon object and it's bitmaps and methods


(defmeth button-icon-proto :draw (&optional show)
  (let* ((w (send self :window))
         (x (send self :x))
         (y (send self :y))
         (state (send self :state))
         (dc (send w :draw-color))
         (bc (send w :back-color))
         )
    (send w :draw-color (send self :draw-color))
    (send w :back-color 'white)
    (cond 
;hilited,selected
      ((or (equal state "hilited") (equal state "selected"))
       (send w :draw-bitmap (send self :hi-icon) x y))
;normal
      ((equal state "normal")
       (send w :draw-bitmap (send self :icon) x y))
;hiblack
      ((equal state "hiblack")
       (send self :draw-color 'black)
       (send w :draw-bitmap (send self :hi-icon) x y))
;black
      ((equal state "black")
       (send self :draw-color 'black)
       (send w :draw-bitmap (send self :icon) x y))
;gray, grey
      ((or (equal state "gray") (equal state "grey"))
       (send self :draw-color 'never-shown-color)
       (send w :draw-bitmap (send self :icon) x y))
;invisible or anything else
      (t
       )
      )
    (send w :draw-color 'black)
    (send w :draw-bitmap (send self :shadow19v) x y)
    (send w :draw-bitmap (send self :shadow19h) x y)
    (send w :draw-bitmap (send self :shadow19v) (+ x 17) y)
    (send w :draw-bitmap (send self :shadow19h) x (+ y 17))
    (send w :draw-bitmap (send self :shadow19v) (+ x 18) (+ y 1))
    (send w :draw-bitmap (send self :shadow19h) (+ x 1) (+ y 18))
    (send w :draw-color dc)
    (send w :back-color bc)))

(defmeth  button-icon-proto :isnew (w x y type color)
  (send self :window w)
  (send self :x x)
  (send self :y y)
  (send self :draw-color (if color color 'never-shown-color))
  (send self :state "normal")

  (send self :shadow19v #2A(
 (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1) (1)))

  (send self :shadow19h #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))

  (cond
    ((equal type 'graph)
     (send self :icon #2A( 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 )
(1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 1 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 1 0 0 0 0 1 0 0 1 0 0 1 ) 
(1 0 1 0 0 1 0 0 0 1 0 0 0 1 ) 
(1 0 1 0 0 0 0 0 1 0 0 0 0 1 ) 
(1 0 1 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 1 0 0 0 1 0 0 0 0 0 0 1 ) 
(1 0 1 0 0 1 0 0 0 1 0 0 0 1 ) 
(1 0 1 0 1 0 1 0 0 0 0 0 0 1 ) 
(1 0 1 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 1 1 1 1 1 1 1 1 1 1 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 )))
     (send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 0 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 0 1 1 1 1 0 1 1 0 1 1 0 ) 
(1 1 0 1 1 0 1 1 1 0 1 1 1 0 ) 
(1 1 0 1 1 1 1 1 0 1 1 1 1 0 ) 
(1 1 0 1 0 1 1 0 1 1 0 1 1 0 ) 
(1 1 0 1 1 1 0 1 1 1 1 1 1 0 ) 
(1 1 0 1 1 0 1 1 1 0 1 1 1 0 ) 
(1 1 0 1 0 1 0 1 1 1 1 1 1 0 ) 
(1 1 0 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 0 0 0 0 0 0 0 0 0 0 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 ))))

    ((equal type 'stats)
     (send self :icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 0) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 1 1) 
(1 0 0 1 1 1 1 1 1 1 1 0 0 1 1) 
(1 0 0 1 0 0 0 0 0 0 1 0 0 1 1) 
(1 0 0 1 1 0 0 0 0 0 1 0 0 1 1) 
(1 0 0 0 1 1 0 0 0 0 0 0 0 1 1) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 1 1) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 1 1) 
(1 0 0 0 1 1 0 0 0 0 1 0 0 1 1) 
(1 0 0 1 1 0 0 0 0 0 1 0 0 1 1) 
(1 0 0 1 0 0 0 0 0 0 1 0 0 1 1) 
(1 0 0 1 1 1 1 1 1 1 1 0 0 1 1) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 1 1) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) 
(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))
     (send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 0) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 0 1) 
(1 1 1 0 0 0 0 0 0 0 0 1 1 0 1) 
(1 1 1 0 1 1 1 1 1 1 0 1 1 0 1) 
(1 1 1 0 0 1 1 1 1 1 0 1 1 0 1) 
(1 1 1 1 0 0 1 1 1 1 1 1 1 0 1) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 0 1) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 0 1) 
(1 1 1 1 0 0 1 1 1 1 0 1 1 0 1) 
(1 1 1 0 0 1 1 1 1 1 0 1 1 0 1) 
(1 1 1 0 1 1 1 1 1 1 0 1 1 0 1) 
(1 1 1 0 0 0 0 0 0 0 0 1 1 0 1) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 0 1) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 1) 
(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1))))


  ((equal type 'stats19)
   (send self :icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )))
   (send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 ) 
(1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 ) 
(1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 ) 
(1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ))))



  ((equal type 'graph19)
   (send self :icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 ) 
(1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 ) 
(1 0 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 ) 
(1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 ) 
(1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )))
   (send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 ) 
(1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 ) 
(1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 ) 
(1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 ) 
(1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 ) 
(1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 )
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ))))
  ((equal type 'help19)
   (send self :icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 ) 
(1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 )
(1 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 ) 
(1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 1 ) 
(1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )))
   (send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 ) 
(1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 ) 
(1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 ) 
(1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 ) 
(1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 ) 
(1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ))))

  (send self :width (first (size (send self :icon))))
  (send self :height (second (size (send self :icon))))
  (call-next-method w x y (send self :height) (send self :width))
  self))